package MusicLandscape.entities;

/**
 * This class represents an artist of performing arts, like a band.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 3
 * @since ExerciseSheet01
 */
public class Artist {
    /**
     * holds the name of the artist
     * <p>
     * initial value should be unknown
     *
     * @since ExerciseSheet01
     */
    private String name = "unknown";

    /**
     * creates a default artist
     * <p>
     * a default artists name is the String "unknown" (without quotes)
     */
    public Artist() {
    }

    /**
     * creates an artist with a certain name
     *
     * @param name the name of this artist
     */
    public Artist(String name) {
        this.name = name;
    }

    /**
     * creates a copy of an artist
     *
     * @param other the original artist to be copied
     */
    public Artist(Artist other) {
        this(other.name);
    }

    /**
     * gets the name of this artist.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * sets the name of this artist.
     * <p>
     * the name of an artist cannot be null or empty. if an invalid argument is passed to the method the state of
     * the object remains unchanged
     *
     * @param name the new name of the artist
     */
    public void setName(String name) {
        if (name == null || name.isBlank()) {
            return;
        }
        this.name = name;
    }

    /**
     * returns a String representation of this Artist
     * <p>
     * This should be either the name of the Artist, or "unknown" if the name is not available
     *
     * @return the string representation
     */
    public String toString() {
        if (name == null || name.isBlank()) {
            return "unknown";
        }
        return name;
    }
}
